<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Application extends Model 
{

    protected $table = 'application';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function module()
    {
        return $this->belongsToMany('\App\Models\Module2', 'application_module');
    }

    public function config()
    {
        return $this->hasMany('\App\Models\Application\Config');
    }

    public function user()
    {
        return $this->hasMany('\App\Models\Application\User');
    }

}